import { useState, useEffect } from "react";
import useAuth from "./useAuth";
import usePreferences from "./usePreferences";

const useGuestUser = () => {
    const { preference: { guest_order } = {} } = usePreferences()
    const { access_token } = useAuth();
    const [isGuest, setIsGuest] = useState(false);

    useEffect(() => {
        if (guest_order === 'enable' && !access_token) {
            setIsGuest(true);
        }
        else {
            setIsGuest(false);
        }
    }, [guest_order, access_token]);

    return isGuest;
};

export default useGuestUser;
